{% set bubbles = [] %}

{# Generate bubbles data based on styles #}
{% if styles == "bubbles-with-dots" %}
    {% for i in 0..(max_limit - 1) %}
        {% set random_top = (random(0, 90) ~ '%') %}
        {% set random_left = (random(0, 90) ~ '%') %}
        {% set random_duration = (random(3, 12) ~ 's') %}
        {% set bubbles = bubbles | merge([{'top': random_top, 'left': random_left, 'duration': random_duration}]) %}
    {% endfor %}
{% elseif styles == "random-bubbles" %}
    {% for i in 0..(max_limit - 1) %}
       {% set random_opacity = random(20, 80) / 100 %}
        {% set random_left = random(0, 95) ~ '%' %}
        {% set random_top = random(0, 95) ~ '%' %}
        {% set random_animation_duration = random(8, 18) ~ 's' %}
        {% set random_transform = 'translate(0, 0) scale(2)' %}

        {% set bubbles = bubbles | merge([{
            'opacity': random_opacity,
            'left': random_left,
            'top': random_top,
            'animation_duration': random_animation_duration,
            'transform': random_transform
        }]) %}
    {% endfor %}
{% endif %}

<div class="bubbles" id="{{ uc_id }}">
    {% for i in 0..(max_limit - 1) %}
        <div class="bubble" 
            {% if styles == "bubbles-with-dots" %}
                style="top: {{ bubbles[i].top }}; left: {{ bubbles[i].left }}; animation-duration: {{ bubbles[i].duration }};"
            {% elseif styles == "random-bubbles" %}
                style="opacity: {{ bubbles[i].opacity }}; 
                       left: {{ bubbles[i].left }}; 
                       top: {{ bubbles[i].top }}; 
                       animation: move-{{ i }} {{ bubbles[i].animation_duration }} infinite; 
                       -moz-transform: {{ bubbles[i].transform }}; 
                       -ms-transform: {{ bubbles[i].transform }}; 
                       -webkit-transform: {{ bubbles[i].transform }}; 
                       transform: {{ bubbles[i].transform }};"
            {% endif %}
        >
            {% if styles == "bubbles-with-dots" %}
                <span class="dot"></span>
            {% endif %}
        </div>
    {% endfor %}
</div>