{% if styles == "simple-bubbles" %}

#{{ uc_id }} .bubble::before {
    background: {{ bubbles_color }};
  	
}
{% endif %}

#{{ uc_id }} .bubbles { 
    position: absolute;
    top: 0;
    left: 0;
    right: 0;
    bottom: 0;
    overflow: hidden;
}

{% if styles == "bubbles-with-dots" %}
#{{ uc_id }} .bubble {
    height: 60px;
    width: 60px;
    border: 2px solid {{ bubbles_color }};
    border-radius: 50%;
    position: absolute; 
    animation: animate linear infinite;
  	background:transparent!important;
}

#{{ uc_id }} .dot {
    height: 10px;
    width: 10px;
    border-radius: 50%;
    background: {{ bubbles_color }};
    position: absolute;
    top: 20%;
    right: 20%;
}

{% for i in 0..(max_limit - 1) %}
#{{ uc_id }} .bubble:nth-child({{ i + 1 }}) {
    top: {{ bubbles[i].top }};
    left: {{ bubbles[i].left }};
    animation-duration: {{ bubbles[i].duration }};
}
{% endfor %}

@keyframes animate {
    0% {
        transform: scale(0) translateY(0) rotate(70deg);
    }
    100% {
        transform: scale(1.3) translateY(-100px) rotate(360deg);
    }
}
{% endif %}

{% if styles == "random-bubbles" %}
#{{ uc_id }} .bubble {
  	 height: 60px;
    width: 60px;
    background-color: {{ bubbles_color }};
    border-radius: 50%;
    position: absolute; 
    
}

{% for i in 0..(max_limit - 1) %}
@keyframes move-{{ i }} {
    {{ random(30, 60) }}% {  /* Randomize the percentage of keyframe */
        -moz-transform: translate({{ random(-100, 100) ~ '%' }}, {{ random(-100, 100) ~ '%' }});
        -webkit-transform: translate({{ random(-100, 100) ~ '%' }}, {{ random(-100, 100) ~ '%' }});
        transform: translate({{ random(-100, 100) ~ '%' }}, {{ random(-100, 100) ~ '%' }});
    }
}
{% endfor %}


{% endif %}