{{ ucfunc("put_docready_start") }}

  var objParallaxWidget = jQuery("#{{uc_id}}");
  var objItems = objParallaxWidget.find(".ue-parallax-item");
  {% set itemsForJs = get_items() %}

  /**
  * get array of orientations
  */
  
  var itemsOrientationArray = [
    {% for item in itemsForJs %}
    "{{item.parallax_orientation}}",
    {% endfor %}
  ]; 

  /**
  * get array of sensitivity
  */
  var itemsSensitivityArray = [
    {% for item in itemsForJs %}
    "{{item.parallax_sensitivity}}",
    {% endfor %}
  ]; 
   
  /**
  * get array of overflows
  */
  var itemsOverflowArray = [
    {% for item in itemsForJs %}
    "{{item.parallax_overflow}}",
    {% endfor %}
  ]; 
   
  /**
  * get array of delays
  */
  var itemsDelayArray = [
    {% for item in itemsForJs %}
    "{{item.parallax_delay}}",
    {% endfor %}
  ];  
   
  /**
  * get array of transitions
  */
  var itemsTransitionArray = [
    {% for item in itemsForJs %}
    "{{item.parallax_transition}}",
    {% endfor %}
  ];  
   
  /**
  * get array of scale directions
  */
  var itemSizeDirectionsArray = [
    {% for item in itemsForJs %}
    "{{item.parallax_scale_direction}}",
    {% endfor %}
  ];  
   
  /**
  * get array of scales
  */
  var itemSizeArray = [
    {% for item in itemsForJs %}
    "{{item.parallax_size}}",
    {% endfor %}
  ];  
   
  /**
  * get array of rotate directions
  */
  var itemRotateDirectionsArray = [
    {% for item in itemsForJs %}
    "{{item.parallax_rotate_direction}}",
    {% endfor %}
  ];  
   
  /**
  * get array of rotates
  */
  var itemRotateArray = [
    {% for item in itemsForJs %}
    "{{item.parallax_rotate_speed}}",
    {% endfor %}
  ];
   
  /**
  * get array of opacity directions
  */
  var itemOpacityDirectionsArray = [
    {% for item in itemsForJs %}
    "{{item.parallax_opacity_direction}}",
    {% endfor %}
  ];  
   
  /**
  * get array of opacities
  */
  var itemOpacityArray = [
    {% for item in itemsForJs %}
    "{{item.parallax_opacity_level}}",
    {% endfor %}
  ];

  /**
  * for each item set its own parallax settings
  */
  objItems.each(function(index, parallaxElement){
  
    new simpleParallax(parallaxElement, {
      
        delay: itemsDelayArray[index], //delay before transition
        orientation: itemsOrientationArray[index], //the direction of the transition
        scale: itemsSensitivityArray[index], //how visible the transition is
        overflow: itemsOverflowArray[index] === "true", //itemsOverflowArray[index] returns string, so make sure it's a boolean value / makes overflow hiden for the image container
        transition: itemsTransitionArray[index], //css transition
        sizeDirection: itemSizeDirectionsArray[index], //whether element is getting bigger or smaller
        sizeSpeed: Number(itemSizeArray[index]), //adjust size of the element during scroll using transform scale(n) css property - the bigger number the faster is change / make sure you set a number
      	rotateDirection: itemRotateDirectionsArray[index], //to right or to left
      	rotateSpeed: Number(itemRotateArray[index]), //how fast is the rotate
        opacityDirection: itemOpacityDirectionsArray[index], //fade-in / fade-out
        opacityLevel: Number(itemOpacityArray[index]) //how transparent element is (the higher number the more transparent becomes element)
      
    });    
  
  });
    	
{{ ucfunc("put_docready_end") }}